function fault_slip_intersect(a,alpha,b,colors,D_center,eps_reg,eta_reg,flag_reg,...
    g,kappa,K_eff,mu_st,nu,p_0_center,phi,rho_f,rho_s,sigma_v_0,theta)
%
% Computes and plots the intersections y_1, y_2, y_3 and y_4 of the combined shear stress with
% the right slip boundary. Uses a numerical and an analytical approach, the latter with and
% without iterative improvement.
%

% Set plot parameters:
n_plot = 100; % number of points in plot, -
p_min = -35e6; % lowest incremental pressure during production, Pa
p_max = -8e6; % highest incremental pressure during production, Pa

% Retrieve colors:
blue = colors(1,:);
green = colors(3,:);

% Production:
p_plot = zeros(n_plot,1);
y_1_el_ana = zeros(n_plot,1);
y_2_el_ana = zeros(n_plot,1);
y_3_el_ana = zeros(n_plot,1);
y_4_el_ana = zeros(n_plot,1);
y_1_el_ana_upd = zeros(n_plot,1);
y_2_el_ana_upd = zeros(n_plot,1);
y_3_el_ana_upd = zeros(n_plot,1);
y_4_el_ana_upd = zeros(n_plot,1);
y_1_el_num = zeros(n_plot,1);
y_2_el_num = zeros(n_plot,1);
y_3_el_num = zeros(n_plot,1);
y_4_el_num = zeros(n_plot,1);
Delta_p = (p_min-p_max)/n_plot;
p_inc = p_max;
for i=1:n_plot
    p_inc = p_inc + Delta_p;
    p_plot(i) = p_inc;
    C = ((1-2*nu)*alpha*p_inc) / (2*pi*(1-nu));
    
    % Compute intersections numerically:
    [y_1_el_num(i),y_2_el_num(i),y_3_el_num(i),y_4_el_num(i)] = ...
    fault_slip_intersect_num(a,alpha,b,0,0,D_center,eps_reg,eta_reg,1,flag_reg,g,kappa,...
    K_eff,0,mu_st,nu,p_0_center,p_inc,phi,rho_f,rho_s,sigma_v_0,theta,0);

    if y_2_el_num(i) ~= 0
        i_max_2_num = i; % maximum number of points in graph of y_2
    end
    if y_3_el_num(i) ~= 0
        i_max_3_num = i; % maximum number of points in graph of y_3
    end  
    
    % Approximate intersections analytically:
     par = [-1 -1 -(a+b)/2 2 2 0 0 1; % parameter table for intersections y_1 to y_4
           -1  1        0 4 2 2 1 1;
            1  1        0 4 2 2 1 1;
            1 -1  (a+b)/2 2 0 2 1 1];
    for j = 1:4
        s_1 = par(j,1);
        s_2 = par(j,2);
        y_tilde = par(j,3);
        f_1 = par(j,4);
        f_2 = par(j,5);
        f_3 = par(j,6);
        d_Om = par(j,7);
        d_Om_Phi = par(j,8);
        [~,~,~,p_0,~,~,~,~,sigma_norm_0,~,~,~,~,~,~,~,sigma_shear_0,~,~,~,~,~] = ...
            fault_slip_sigma(a,alpha,b,0,0,D_center,1,g,kappa,K_eff,...
            0,mu_st,1,nu,p_0_center,p_inc,phi,rho_f,rho_s,sigma_v_0,theta,0,y_tilde,y_tilde);
        g_1 = ( sigma_shear_0 - kappa + mu_st * ...
            (sigma_norm_0 + alpha * (p_0 + p_inc*d_Om_Phi)) ) / C - mu_st * 2*pi * d_Om;
        g_2 = -(pi/2) * ( f_1 * sin(theta) * cos(theta) + ...
            mu_st * ( f_2 * (sin(theta))^2 - f_3 * (1 + (cos(theta))^2 ) ) );
        g_3 = -(1/2) * ( (sin(theta))^2 - mu_st * (sin(theta)*cos(theta)) );
        gamma = exp( (g_1 + g_2) / g_3 );
        y = s_1 * sqrt( (gamma*b^2 + s_2 * sqrt(gamma)*(b^2-a^2) - a^2) / (gamma-1) );
        if j == 1
            y_1_el_ana(i) = y;
        end
        if j == 2
            y_2_el_trial = y;
            if isreal(y_2_el_trial) % complex value: slip patches have merged
                y_2_el_ana(i) =  y_2_el_trial;
                i_max_2_ana = i;
            end
        end
        if j == 3
            y_3_el_trial = y;
            if isreal(y_3_el_trial) % complex value: slip patches have merged
                y_3_el_ana(i) =  y_3_el_trial;
                i_max_3_ana = i;
            end
        end
        if j == 4
            y_4_el_ana(i) = y;
        end
    end
    
    % Iterate with updated values of y_tilde:
    y_1_el_ana_upd(i) = y_1_el_ana(i); % intialization of iterative improvement
    y_2_el_ana_upd(i) = y_2_el_ana(i);
    y_3_el_ana_upd(i) = y_3_el_ana(i);
    y_4_el_ana_upd(i) = y_4_el_ana(i);
%    resid = 1;
    resid_rel = 1;
    i_it = 0;
    maxit = 100;
%    while resid > 1e-3
    while resid_rel > 1e-3
        i_it = i_it + 1;
        if i_it > maxit
            error('Maximum allowed number of iterations exceeded.')
        end
        y_1_el_ana_old = y_1_el_ana_upd(i); % intialization of iterative improvement
        y_2_el_ana_old = y_2_el_ana_upd(i);
        y_3_el_ana_old = y_3_el_ana_upd(i);
        y_4_el_ana_old = y_4_el_ana_upd(i);
        par(1:4,3) = [y_1_el_ana_upd(i);y_2_el_ana_upd(i);y_3_el_ana_upd(i);y_4_el_ana_upd(i)];
        % updated values of y_tilde
        for j = 1:4
            s_1 = par(j,1);
            s_2 = par(j,2);
            y_tilde = par(j,3);
            f_1 = par(j,4);
            f_2 = par(j,5);
            f_3 = par(j,6);
            d_Om = par(j,7);
            d_Om_Phi = par(j,8);
            [~,~,~,p_0,~,~,~,~,sigma_norm_0,~,~,~,~,~,~,~,sigma_shear_0,~,~,~,~,~] = ...
                fault_slip_sigma(a,alpha,b,0,0,D_center,1,g,kappa,K_eff,...
                0,mu_st,1,nu,p_0_center,p_inc,phi,rho_f,rho_s,sigma_v_0,theta,0,y_tilde,...
                y_tilde);
            g_1 = ( sigma_shear_0 - kappa + mu_st * ...
                (sigma_norm_0 + alpha * (p_0 + p_inc*d_Om_Phi)) ) / C - mu_st * 2*pi * d_Om;
            g_2 = -(pi/2) * ( f_1 * sin(theta) * cos(theta) + ...
                mu_st * ( f_2 * (sin(theta))^2 - f_3 * (1 + (cos(theta))^2 ) ) );
            g_3 = -(1/2) * ( (sin(theta))^2 - mu_st * (sin(theta)*cos(theta)) );
            gamma = exp( (g_1 + g_2) / g_3 );
            y = s_1 * sqrt( (gamma*b^2 + s_2 * sqrt(gamma)*(b^2-a^2) - a^2) / (gamma-1) );
            if j == 1
                y_1_el_ana_upd(i) = y;
            end
            if j == 2
                y_2_el_trial = y;
                if isreal(y_2_el_trial) % complex value: slip patches have merged
                    y_2_el_ana_upd(i) =  y_2_el_trial;
                    i_max_2_ana_upd = i;
                end
            end
            if j == 3
                y_3_el_trial = y;
                if isreal(y_3_el_trial) % complex value: slip patches have merged
                    y_3_el_ana_upd(i) =  y_3_el_trial;
                    i_max_3_ana_upd = i;
                end
            end
            if j == 4
                y_4_el_ana_upd(i) = y;
            end
        end
%         resid = sqrt(   (y_1_el_ana_upd(i) - y_1_el_ana_old)^2 ...
%                       + (y_2_el_ana_upd(i) - y_2_el_ana_old)^2 ...
%                       + (y_3_el_ana_upd(i) - y_3_el_ana_old)^2 ...
%                       + (y_4_el_ana_upd(i) - y_4_el_ana_old)^2 );
        resid_rel = sqrt(   ((y_1_el_ana_upd(i) - y_1_el_ana_old) / y_1_el_ana_old)^2 ...
                          + ((y_2_el_ana_upd(i) - y_2_el_ana_old) / y_2_el_ana_old)^2 ...
                          + ((y_3_el_ana_upd(i) - y_3_el_ana_old) / y_3_el_ana_old)^2 ...
                          + ((y_4_el_ana_upd(i) - y_4_el_ana_old) / y_4_el_ana_old)^2 );
    end
% % %     [i i_it] 
end

% Truncate plot arrays for y_2_el_num and y_3_el_num to avoid plotting for pr. above p_merge:
p_plot_2_num_plot = p_plot(1:min(i_max_2_num+1,n_plot));
p_plot_3_num_plot = p_plot(1:min(i_max_3_num+1,n_plot));
y_2_el_num_plot = y_2_el_num(1:min(i_max_2_num+1,n_plot));
y_3_el_num_plot = y_3_el_num(1:min(i_max_3_num+1,n_plot));

% Truncate plot arrays for y_2_el_ana and y_3_el_ana to avoid plotting for pr. above p_merge:
p_plot_2_ana_plot = p_plot(1:min(i_max_2_ana+1,n_plot));
p_plot_3_ana_plot = p_plot(1:min(i_max_3_ana+1,n_plot));
y_2_el_ana_plot = y_2_el_ana(1:min(i_max_2_ana+1,n_plot));
y_3_el_ana_plot = y_3_el_ana(1:min(i_max_3_ana+1,n_plot));

% Truncate plot arrays for y_2_el_ana_upd and y_3_el_ana_upd to avoid pl. f. pr. above p_merge:
p_plot_2_ana_upd_plot = p_plot(1:min(i_max_2_ana_upd+1,n_plot));
p_plot_3_ana_upd_plot = p_plot(1:min(i_max_3_ana_upd+1,n_plot));
y_2_el_ana_upd_plot = y_2_el_ana_upd(1:min(i_max_2_ana_upd+1,n_plot));
y_3_el_ana_upd_plot = y_3_el_ana_upd(1:min(i_max_3_ana_upd+1,n_plot));

% Plot results:
figure % numerical and analytical results
plot(-p_plot/1e6,y_1_el_num,'-r','LineWidth',1.5);
hold on
plot(-p_plot_2_num_plot/1e6,y_2_el_num_plot,'-','Color',blue,'LineWidth',1.5);
plot(-p_plot_3_num_plot/1e6,y_3_el_num_plot,'-','Color',green,'LineWidth',1.5);
plot(-p_plot/1e6,y_4_el_num,'-k','LineWidth',1.5);
plot(-p_plot/1e6,y_1_el_ana,'-ro','LineWidth',1.5,'MarkerSize',4,...
    'MarkerFaceColor','r','MarkerIndices',1:4:length(p_plot));
plot(-p_plot_2_ana_plot/1e6,y_2_el_ana_plot,'-o','Color',blue,'LineWidth',1.5,...
    'MarkerSize',4,'MarkerFaceColor','b','MarkerIndices',1:4:length(p_plot_2_ana_plot));
plot(-p_plot_3_ana_plot/1e6,y_3_el_ana_plot,'-o','Color',green,'LineWidth',1.5,...
    'MarkerSize',4,'MarkerFaceColor',green,'MarkerIndices',1:4:length(p_plot_3_ana_plot));
plot(-p_plot/1e6,y_4_el_ana,'-ko','LineWidth',1.5,'MarkerSize',4,...
    'MarkerFaceColor','k','MarkerIndices',1:4:length(p_plot));
line([ 0 35],[   0    0],'LineStyle','-','Color','k','LineWidth',0.5) % hor. line at y = 0 m
%line([15 15],[ -150 150],'LineStyle','--','Color','k','LineWidth',0.5) % vertical line
line([25 25],[ -150 150],'LineStyle','--','Color','k','LineWidth',0.5) % vertical line
%line([35 35],[ -150 150],'LineStyle',':','Color','k','LineWidth',0.5) % vertical line
plot(-p_plot_3_ana_plot(end)/1e6,y_3_el_ana_plot(end),'-o','Color',green,'LineWidth',1.5,...
    'MarkerSize',4,'MarkerFaceColor',green); % cosmetic correction (marker at last point)
hold off
xlabel('\it-p \rm(MPa)')
ylabel('\ity_i \rm(m)')
legend('\ity_{1,num}','\ity_{2,num}','\ity_{3,num}','\ity_{4,num}',...
    '\ity_{1,ana}','\ity_{2,ana}','\ity_{3,ana}','\ity_{4,ana}'...
    ,'location','west')
axis([10 30 -100 100])

figure % numerical,analytical and iteratively updated analytical results
plot(-p_plot/1e6,y_1_el_num,'-r','LineWidth',1.5);
hold on
plot(-p_plot_2_num_plot/1e6,y_2_el_num_plot,'-','Color',blue,'LineWidth',1.5);
plot(-p_plot_3_num_plot/1e6,y_3_el_num_plot,'-','Color',green,'LineWidth',1.5);
plot(-p_plot/1e6,y_4_el_num,'-k','LineWidth',1.5);
% plot(-p_plot/1e6,y_1_el_ana,'--ro','LineWidth',1.5,'MarkerSize',4,...
%     'MarkerFaceColor','r','MarkerIndices',1:4:length(p_plot));
plot(-p_plot/1e6,y_1_el_ana,':r','LineWidth',1.5,'MarkerSize',4,...
    'MarkerFaceColor','r','MarkerIndices',1:4:length(p_plot));
% plot(-p_plot_2_ana_plot/1e6,y_2_el_ana_plot,'--o','Color',blue,'LineWidth',1.5,...
%   'MarkerSize',4,'MarkerFaceColor',blue,'MarkerIndices',1:4:length(p_plot_2_ana_plot));
plot(-p_plot_2_ana_plot/1e6,y_2_el_ana_plot,':','Color',blue,'LineWidth',1.5,'MarkerSize',4,...
    'MarkerFaceColor',blue,'MarkerIndices',1:4:length(p_plot_2_ana_plot));
% plot(-p_plot_3_ana_plot/1e6,y_3_el_ana_plot,'--o','Color',green,'LineWidth',1.5,...
%   'MarkerSize',4,'MarkerFaceColor',green,'MarkerIndices',1:4:length(p_plot_3_ana_plot));
plot(-p_plot_3_ana_plot/1e6,y_3_el_ana_plot,':','Color',green,'LineWidth',1.5,...
    'MarkerSize',4,'MarkerFaceColor',green,'MarkerIndices',1:4:length(p_plot_3_ana_plot));
% plot(-p_plot/1e6,y_4_el_ana,'--ko','LineWidth',1.5,'MarkerSize',4,...
%     'MarkerFaceColor','k','MarkerIndices',1:4:length(p_plot));
plot(-p_plot/1e6,y_4_el_ana,':k','LineWidth',1.5,'MarkerSize',4,...
    'MarkerFaceColor','k','MarkerIndices',1:4:length(p_plot));
% plot(-p_plot/1e6,y_1_el_ana_upd,':r^','LineWidth',1.5,'MarkerSize',7,...
%     'MarkerIndices',1:4:length(p_plot));
plot(-p_plot/1e6,y_1_el_ana_upd,'ro','LineWidth',1.5,'MarkerSize',4,...
    'MarkerFaceColor','r','MarkerIndices',1:4:length(p_plot));
% plot(-p_plot_2_ana_upd_plot/1e6,y_2_el_ana_upd_plot,':^','Color',blue,'LineWidth',1.5,...
%   'MarkerSize',7,'MarkerIndices',1:4:length(p_plot_2_ana_upd_plot));
plot(-p_plot_2_ana_upd_plot/1e6,y_2_el_ana_upd_plot,'o','Color',blue,'LineWidth',1.5,...
    'MarkerSize',4,'MarkerFaceColor',blue,'MarkerIndices',1:4:length(p_plot_2_ana_upd_plot));
% plot(-p_plot_3_ana_upd_plot/1e6,y_3_el_ana_upd_plot,':g^','LineWidth',1.5,'MarkerSize',7,...
%     'MarkerIndices',1:4:length(p_plot_3_ana_upd_plot));
plot(-p_plot_3_ana_upd_plot/1e6,y_3_el_ana_upd_plot,'o','Color',green,'LineWidth',1.5,...
    'MarkerSize',4,'MarkerFaceColor',green,'MarkerIndices',1:4:length(p_plot_3_ana_upd_plot));
% plot(-p_plot/1e6,y_4_el_ana_upd,':k^','LineWidth',1.5,'MarkerSize',7,...
%     'MarkerIndices',1:4:length(p_plot));
plot(-p_plot/1e6,y_4_el_ana_upd,'ko','LineWidth',1.5,'MarkerSize',4,...
    'MarkerFaceColor','k','MarkerIndices',1:4:length(p_plot));
line([ 0 35],[   0    0],'LineStyle','-','Color','k','LineWidth',0.5) % horizontal line
%line([15 15],[ -150 150],'LineStyle','--','Color','k','LineWidth',0.5) % vertical line
line([25 25],[ -150 150],'LineStyle','--','Color','k','LineWidth',0.5) % vertical line
%line([35 35],[ -150 150],'LineStyle',':','Color','k','LineWidth',0.5) % vertical line
plot(-p_plot_3_ana_plot(end)/1e6,y_3_el_ana_plot(end),'-','Color',green,'LineWidth',1.5,...
    'MarkerSize',4,'MarkerFaceColor',green); % cosmetic correction (marker at last point)
plot(-p_plot_3_ana_plot(end)/1e6,y_3_el_ana_plot(end),'o','Color',green,'LineWidth',1.5,...
    'MarkerSize',4,'MarkerFaceColor',green); % cosmetic correction (marker at last point)
hold off
xlabel('\it-p \rm(MPa)')
ylabel('\ity_i \rm(m)')
legend('\ity_{1,num}','\ity_{2,num}','\ity_{3,num}','\ity_{4,num}',...
    '\ity_{1,ana}','\ity_{2,ana}','\ity_{3,ana}','\ity_{4,ana}',...
    '\ity_{1,ana,upd}','\ity_{2,ana,upd}','\ity_{3,ana,upd}','\ity_{4,ana,upd}'...
    ,'location','west')
axis([10 30 -100 100])

